import { Component, DestroyRef, inject, OnInit } from '@angular/core';
import { FormBuilder, FormControl, FormGroup, FormsModule, ReactiveFormsModule, Validators } from '@angular/forms';
import { MatSnackBar, MatSnackBarModule } from '@angular/material/snack-bar';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { MatOptionModule } from '@angular/material/core';
import { MatSelectModule } from '@angular/material/select';
import { MatInputModule } from '@angular/material/input';
import { MatFormFieldModule } from '@angular/material/form-field';
import { MatIconModule } from '@angular/material/icon';
import { MatButtonModule } from '@angular/material/button';
import { LoadingService } from 'src/services/loading.service';
import { ActivatedRoute, Router } from '@angular/router';
import { TranslateModule, TranslateService } from '@ngx-translate/core';
import { MatAutocompleteModule } from '@angular/material/autocomplete';
import { HttpClientModule } from '@angular/common/http';
import { MatCardModule } from '@angular/material/card';
import { MatProgressBarModule } from '@angular/material/progress-bar';
import { MatRadioModule } from '@angular/material/radio';
import { MatSlideToggleModule } from '@angular/material/slide-toggle';
import { MatTooltipModule } from '@angular/material/tooltip';
import { MatDialog, MatDialogModule } from '@angular/material/dialog';
import { MatExpansionModule } from '@angular/material/expansion';
import { MatDatepickerModule } from '@angular/material/datepicker';
import { MatDividerModule } from '@angular/material/divider';
import { MatButtonToggleModule } from '@angular/material/button-toggle';
import { scaleIn400ms } from '@vex/animations/scale-in.animation';
import { fadeInRight400ms } from '@vex/animations/fade-in-right.animation';
import { UploaderComponent } from 'src/app/components/uploader/uploader.component';
import { MatSliderModule } from '@angular/material/slider';
import { SelectLanguageComponent } from 'src/app/components/select/select-language/select-language.component';
import { HeaderComponent } from '../../components/header/header.component';
import { HeaderData } from '../../components/header/header.model';
import { ProjectDetailsComponent } from "../../components/project-details/project-details.component";
import { ProjectNotesComponent } from "../../components/project-notes/project-notes.component";
import { moreInfoService } from '../../components/more-info.service';
import { takeUntilDestroyed } from '@angular/core/rxjs-interop';
import { ApiService } from 'src/services/api.service';
import { ConfirmDialogComponent } from 'src/app/components/ui/confirm-dialog/confirm-dialog.component';
import { SelectVoiceComponent } from "src/app/components/select/select-voice/select-voice.component";
import { MatMenuModule } from '@angular/material/menu';
import { RenameDialogComponent } from 'src/app/components/ui/rename-dialog/rename-dialog.component';
import { ProjectDetailsForm, voiceFormGlobal } from 'src/models/global.model';
import { SecurityService } from 'src/services/security/security.service';
import { ManageUsersDialogComponent } from '../../video/lumo/manage-users-dialog/manage-users-dialog.component';
import { ServicesService } from 'src/services/services.service';

@Component({
  selector: 'vex-lumo',
  standalone: true,
  imports: [
    FormsModule,
    MatButtonModule,
    MatButtonToggleModule,
    ReactiveFormsModule,
    MatFormFieldModule,
    MatInputModule,
    MatSelectModule,
    MatOptionModule,
    MatSnackBarModule,
    MatCardModule,
    MatIconModule,
    MatProgressBarModule,
    MatDividerModule,
    HttpClientModule,
    TranslateModule,
    MatMenuModule,
    MatRadioModule,
    MatIconModule,
    MatCheckboxModule,
    MatSlideToggleModule,
    MatTooltipModule,
    MatDialogModule,
    MatExpansionModule,
    MatSliderModule,
    HeaderComponent,
    ProjectDetailsComponent,
    ProjectNotesComponent,
    SelectLanguageComponent,
    UploaderComponent,
    SelectVoiceComponent
  ],
  animations: [
    scaleIn400ms,
    fadeInRight400ms
  ],
  templateUrl: './podcast.component.html',
  styleUrls: ['./podcast.component.scss']
})
export class PodcastComponent implements OnInit {
  private readonly destroyRef: DestroyRef = inject(DestroyRef);

  // PAGE DETAILS
  currService = this.servicesService.services.find(service => service.label === 'Podcast');
  headerData: HeaderData = {
    title: this.currService.label,
    icon: this.currService.icon_2,
    projectType: this.currService.type,
    crumbs: [{ link: '/create', title: 'Create' }, { link: this.currService.createUrl, title: this.currService.label }]
  };

  // PROJECT PROPERTIES
  // UI PROPERTIES
  showErrorsCtrl = new FormControl(false);
  isTouched = false;

  // PROJECT FORM
  mainForm: FormGroup = new FormGroup({
    projectDetails: new FormGroup<ProjectDetailsForm>({
      projectName: new FormControl('', [Validators.required]),
      startLanguage: new FormControl(''),
      projectOwner: new FormControl(null, []),
      projectManager: new FormControl(null, []),
      setDates: new FormControl(false, []),
      startDate: new FormControl(new Date(), []),
      endDate: new FormControl(null, []),
      endTime: new FormControl('12:00', []),
      projectNotes: new FormControl('', []),
      internalID: new FormControl(null, []),
      targetLanguages: new FormControl([]),
    }),
    projectSettings: new FormGroup({
    }),
  });

  constructor(
    protected loadingService: LoadingService,
    protected moreInfoService: moreInfoService,
    public translate: TranslateService,
    private route: ActivatedRoute,
    private apiService: ApiService,
    private dialog: MatDialog,
    private snackbar: MatSnackBar,
    private fb: FormBuilder,
    private router: Router,
    private securityService: SecurityService,
    private servicesService: ServicesService
  ) { }

  ngOnInit(): void {
    this.route.queryParams.subscribe(params => {
      this.projectNameCtrl.setValue(params['projectName']);
    });

    // INITIALIZATIONS

    // SUBSCRIPTIONS
  }

  // FUNCTIONS
  // FUNCTIONS
  // FUNCTIONS

  // OTHER
  // OTHER
  // OTHER


  // SUBMIT
  // SUBMIT
  // SUBMIT
  formSubmit() {
  }

  // UI SECTION
  // UI SECTION
  // UI SECTION

  // GETTERS
  // Form Groups
  get projectDetailsGroup() {
    return this.mainForm.get('projectDetails') as FormGroup;
  }

  // Form Controls
  get projectNameCtrl() {
    return this.projectDetailsGroup.get('projectName') as FormControl;
  }

}